/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.python.antlr.base.mod;
import org.python.compiler.Module;
import org.python.core.BytecodeLoader;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PythonCodeBundle;
import org.python.core.PythonCompiler;

public class LegacyCompiler
implements PythonCompiler {
    public PythonCodeBundle compile(mod mod2, String string, String string2, boolean bl, boolean bl2, CompilerFlags compilerFlags) {
        return new LazyLegacyBundle(mod2, string, string2, bl, bl2, compilerFlags);
    }

    private static class LazyLegacyBundle
    implements PythonCodeBundle {
        private final mod node;
        private final String name;
        private final String filename;
        private final boolean linenumbers;
        private final boolean printResults;
        private final CompilerFlags cflags;
        private ByteArrayOutputStream ostream = null;

        public LazyLegacyBundle(mod mod2, String string, String string2, boolean bl, boolean bl2, CompilerFlags compilerFlags) {
            this.node = mod2;
            this.name = string;
            this.filename = string2;
            this.linenumbers = bl;
            this.printResults = bl2;
            this.cflags = compilerFlags;
        }

        public PyCode loadCode() throws Exception {
            return BytecodeLoader.makeCode(this.name, this.ostream().toByteArray(), this.filename);
        }

        public void writeTo(OutputStream outputStream) throws Exception {
            if (this.ostream != null) {
                outputStream.write(this.ostream.toByteArray());
            } else {
                Module.compile(this.node, outputStream, this.name, this.filename, this.linenumbers, this.printResults, this.cflags);
            }
        }

        public void saveCode(String string) throws Exception {
            Py.saveClassFile(this.name, this.ostream());
        }

        private ByteArrayOutputStream ostream() throws Exception {
            if (this.ostream == null) {
                this.ostream = new ByteArrayOutputStream();
                Module.compile(this.node, this.ostream, this.name, this.filename, this.linenumbers, this.printResults, this.cflags);
            }
            return this.ostream;
        }
    }
}

